/* ***** BEGIN LICENSE BLOCK *****
 * This file is part of DotClear.
 * Copyright (c) 2004-2007 Olivier Meunier and contributors. All rights
 * reserved.
 *
 * DotClear is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * DotClear is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with DotClear; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * ***** END LICENSE BLOCK ***** */

function popup(url)
{
	window.open(url,'dc_popup',
	'alwaysRaised=yes,dependent=yes,toolbar=no,height=420,width=500,menubar=no,resizable=yes,scrollbars=yes,status=no');
}

function limitArea(e,limit)
{
	if (e.value.length > limit) {
		e.value = e.value.substring(0,limit);
	}
}

function setNow()
{
	var now = new Date();
	var y = now.getFullYear();
	var m = now.getMonth();
	var d = now.getDate();
	var h = now.getHours();
	var i = now.getMinutes();
	var s = now.getSeconds();
	
	if (m.length == 1) {
		m = '0'+m;
	}
	
	$('#p_dt_y').val(y);
	($('#p_dt_m')[0]).selectedIndex = m;
	$('#p_dt_d').val(d);
	$('#p_dt_h').val(h);
	$('#p_dt_i').val(i);
	$('#p_dt_s').val(s);
}

function str2url(str,encoding,ucfirst)
{
	str = str.toUpperCase();
	str = str.toLowerCase();
	
	str = str.replace(/[\u00E0\u00E1\u00E2\u00E3\u00E4\u00E5]/g,'a');
	str = str.replace(/[\u00E7]/g,'c');
	str = str.replace(/[\u00E8\u00E9\u00EA\u00EB]/g,'e');
	str = str.replace(/[\u00EC\u00ED\u00EE\u00EF]/g,'i');
	str = str.replace(/[\u00F2\u00F3\u00F4\u00F5\u00F6\u00F8]/g,'o');
	str = str.replace(/[\u00F9\u00FA\u00FB\u00FC]/g,'u');
	str = str.replace(/[\u00FD\u00FF]/g,'y');
	str = str.replace(/[\u00F1]/g,'n');
	str = str.replace(/[\u0153]/g,'oe');
	str = str.replace(/[\u00E6]/g,'ae');
	str = str.replace(/[\u00DF]/g,'ss');
	
	str = str.replace(/[^a-z0-9_\s\'\:\/\[\]-]/g,'');
	str = trim(str);
	str = str.replace(/[\s\'\:\/\[\]-]+/g,' ');
	str = str.replace(/[ ]/g,'-');
	
	if (ucfirst == 1) {
		c = str.charAt(0);
		str = c.toUpperCase()+str.slice(1);
	}
	
	return str;
}

function trim(s) {
	s = s.replace(/[ ]*$/,'');
	s = s.replace(/^[ ]*/,'');
	return s;
}

/* The following stuff appeared in DC 1.2.7 */
/* ChainHandler, py Peter van der Beken
-------------------------------------------------------- */
function chainHandler(obj, handlerName, handler) {
	obj[handlerName] = (function(existingFunction) {
		return function() {
			handler.apply(this, arguments);
			if (existingFunction)
				existingFunction.apply(this, arguments); 
		};
	})(handlerName in obj ? obj[handlerName] : null);
};


/* jQuery extensions
-------------------------------------------------------- */
jQuery.fn.check = function() {
	return this.each(function() {
		if (this.checked != undefined && !this.disabled) { this.checked = true; }
	});
};
jQuery.fn.toggleCheck = function() {
	return this.each(function() {
		if (this.checked != undefined && !this.disabled) { this.checked = !this.checked; }
	});
};
jQuery.fn.radioVal = function() {
	var res = null;
	this.each(function() {
		if (this.checked != undefined && this.checked) {
			res = this.value;
		}
	});
	return res;
};

jQuery.fn.optionalToggle = function(target,s) {
	var defaults = {
		img_on: 'images/plus.png',
		img_off: 'images/moins.png',
		hide: true,
		cookie: false
	};
	var p = jQuery.extend(defaults,s);
	
	if (!target) { return this; }
	
	var set_cookie = p.hide;
	if (p.cookie && jQuery.cookie(p.cookie)) {
		p.hide = false;
	}
	
	var toggle = function(i) {
		if (p.hide) {
			target.hide();
			if (p.cookie && set_cookie) {
				jQuery.cookie(p.cookie,'',{expires: -1});
			}
		} else {
			target.show();
			if (p.fn) {
				p.fn.apply(target);
				p.fn = false;
			}
			if (p.cookie && set_cookie) {
				jQuery.cookie(p.cookie,1,{expires: 30});
			}
		}
		p.hide = !p.hide;
		$(i).get(0).src = p.hide ? p.img_off : p.img_on;
	};
	
	return this.each(function() {
		$(this).css('cursor','pointer');
		$(this).click(function() {
			toggle(this);
		});		
		toggle($(this).get(0));
	});
};

/* Dotclear common object
-------------------------------------------------------- */
var dotclear = {
	msg: {
		show_all: 'show all',
		hide_all: 'hide all',
		select_all: 'select all',
		invert_sel: 'invert selection',
		
		confirm_delete_posts: 'Are you sure you want to delete selected entries?',
		confirm_delete_comments: 'Are you sure you want to delete selected comments?',
		confirm_delete_trackbacks: 'Are you sure you want to delete selected trackbacks?',
		confirm_delete_comment: 'Are you sure you want to delete this comment?',
		confirm_delete_user: 'Are you sure you want to delete selected users?',
		confirm_delete_categories: 'Are you sure you want to delete the selected categories?'
	},
	
	checkboxesHelpers: function(e) {
		var a = document.createElement('a');
		a.href='#';
		$(a).append(document.createTextNode(dotclear.msg.select_all));
		a.onclick = function() {
			$(this).parents('form').find('input[@type="checkbox"]').check();
			return false;
		};
		$(e).append(a);
		
		$(e).append(document.createTextNode(' - '));
		
		a = document.createElement('a');
		a.href='#';
		$(a).append(document.createTextNode(dotclear.msg.invert_sel));
		a.onclick = function() {
			$(this).parents('form').find('input[@type="checkbox"]').toggleCheck();
			return false;
		};
		$(e).append(a);
	},

	toggleImgs: function(e) {
		$(e).css('cursor','pointer');
		$(e).click(function() {
			var trgId = '#'+$(e).attr('id').replace('img_','');
			$(trgId).each(function() {
				if ($(this).css('display') == 'none') {
					$(e).attr('src','images/moins.png');
				}
				else	{
					$(e).attr('src','images/plus.png');
				}
				$(this).toggle();
			});
		});
	},

	toggleHelpers: function(e) {
		var a = document.createElement('a');
		var trg = '#'+$(e).attr('id').replace('trg_','');
		a.href='#';
		$(a).append(document.createTextNode(dotclear.msg.show_all));
		a.onclick = function() {
			$(trg+' .toggle-imgs').each(function() {
				var trgId = '#'+$(this).attr('id').replace('img_','');
				var i = $(this);
				$(trgId).each(function() {
					$(this).css('display','block');
					$(i).attr('src','images/moins.png');
				});
			});
			return false;
		};
		$(e).append(a);

		$(e).append(document.createTextNode(' - '));

		a = document.createElement('a');
		a.href='#';
		$(a).append(document.createTextNode(dotclear.msg.hide_all));
		a.onclick = function() {
			$(trg+' .toggle-imgs').each(function() {
				var trgId = '#'+$(this).attr('id').replace('img_','');
				var i = $(this);
				$(trgId).each(function() {
					$(this).css('display','none');
					$(i).attr('src','images/plus.png');
				});
			});
			return false;
		};
		$(e).append(a);
	},

	postsActionsHelper: function() {
		$('#form-entries').submit(function() {
			var action = $(this).find('select[@name="psts_action"]').val();
			var checked = false;
			
			$(this).find('input[@name="p_ids[]"]').each(function() {
				if (this.checked) {
					checked = true;
				}
			});
			
			if (!checked) { return false; }
			
			if (action == 'delete') {
				return window.confirm(dotclear.msg.confirm_delete_posts);
			}
	
			return true;
		});
	},
	
	commentsActionsHelper: function() {
		$('#form-comments').submit(function() {
			var action = $(this).find('select[@name="cmts_action"]').val();
			var checked = false;
			
			$(this).find('input[@name="c_ids[]"]').each(function() {
				if (this.checked) {
					checked = true;
				}
			});
			
			if (!checked) { return false; }
			
			if (action == 'delete') {
				return window.confirm(dotclear.msg.confirm_delete_comments);
			}
			
			return true;
		});
	},
	
	trackbacksActionsHelper: function() {
		$('#form-trackbacks').submit(function() {
			var action = $(this).find('select[@name="cmts_action"]').val();
			var checked = false;
			
			$(this).find('input[@name="c_ids[]"]').each(function() {
				if (this.checked) {
					checked = true;
				}
			});
			
			if (!checked) { return false; }
			
			if (action == 'delete') {
				return window.confirm(dotclear.msg.confirm_delete_trackbacks);
			}
					
			return true;
		});
	}
};